<?php
/**
 * Fraktur Converter Class
 */


class Fraktur {
	public static $fontOffsets = Array(
		"Fraktur"      => Array(120068, 120094),
		"BoldFraktur"  => Array(120172, 120198),
		"Script"       => Array(119964, 119990),
		"BoldScript"   => Array(120016, 120042),
		"DoubleStruck" => Array(120120, 120146, 120792),
		"Monospace"    => Array(120432, 120458, 120822),
	);
	public static $fontPrettyNames = Array(
		"Fraktur"      => "Fraktur",
		"BoldFraktur"  => "Fraktur (Fett)",
		"Script"       => "Handschrift",
		"BoldScript"   => "Handschrift (Fett)",
		"DoubleStruck" => "Doppel-Strich",
		"Monospace"    => "Nichtproportional"
	);
	public static $FixUnexpectedWrongCodepoint = Array(
		"1d49d" => "212c", # ℬ
		"1d4a0" => "2130", # ℰ
		"1d4a1" => "2131", # ℱ
		"1d4a3" => "210b", # ℋ
		"1d4a4" => "2110", # ℐ
		"1d4a7" => "2112", # ℒ
		"1d4a8" => "2133", # ℳ
		"1d4ad" => "211b", # ℛ
		"1d4ba" => "212f", # ℯ
		"1d4bc" => "210a", # ℊ
		"1d4c4" => "2134", # ℴ
		"1d506" => "212d", # ℭ
		"1d50b" => "210c", # ℌ
		"1d50c" => "2111", # ℑ
		"1d515" => "211c", # ℜ
		"1d51d" => "2128", # ℨ
		"1d53a" => "2102", # ℂ
		"1d53f" => "210d", # ℍ
		"1d545" => "2115", # ℕ
		"1d547" => "2119", # ℙ
		"1d548" => "211a", # ℚ
		"1d549" => "211d", # ℝ
		"1d551" => "2124", # ℤ
	);

	public static function getFontPrettyName($font) {
		try {
			return Fraktur::$fontPrettyNames[$font];
		} catch (Exception $e) {
			return NULL;
		}
	}
	public static function char2fraktur($c, $font) {
		if (mb_strlen($c) > 1)
			$c = mb_substr($c, 0, 1);
			
		$offsets       = Fraktur::$fontOffsets[$font];
		$offsetCapital = $offsets[0];
		$offsetSmall   = $offsets[1];
		$offsetDigit   = count($offsets) > 2 ? $offsets[2] : 0;
		
		if (mb_ord('A') <= mb_ord($c) && mb_ord($c) <= mb_ord('Z')) {
			// Capital Letters
			$f = mb_chr($offsetCapital + mb_ord($c)-mb_ord('A'));
			
		} elseif (mb_ord('a') <= mb_ord($c) && mb_ord($c) <= mb_ord('z')) {
			// Small Letters
			$f = mb_chr($offsetSmall + mb_ord($c)-mb_ord('a'));
			
		} elseif ($offsetDigit>0 && mb_ord('0') <= mb_ord($c) && mb_ord($c) <= mb_ord('9')) {
			// Digits (only if special digits exist)
			$f = mb_chr($offsetDigit + mb_ord($c)-mb_ord('0'));
			
		} else {
			$f = $c;
			
		}
		
		// Fix wring codepoints (see README.md for details)
		if (array_key_exists(dechex(mb_ord($f)), Fraktur::$FixUnexpectedWrongCodepoint)) {
			$f = mb_chr(
				hexdec(
					Fraktur::$FixUnexpectedWrongCodepoint[ dechex(mb_ord($f)) ]
				)
			);
			
		}
		
		return $f;
	}
	public static function string2fraktur($input_string, $font = "BoldFraktur", $replace_umlauts = FALSE) {
		if (!array_key_exists($font, Fraktur::$fontOffsets)) {
			throw new Exception("Invalid font!");
		}
		
		$fraktur = "";
		
		if ($replace_umlauts) {
			$input_string = str_replace(
				Array("ä",  "Ä",  "ö",  "Ö",  "ü",  "Ü",  "ß",  "ẞ"), 
				Array("ae", "Ae", "oe", "Oe", "ue", "Ue", "ss", "SS"),
				$input_string
			);
		}
		
		for ($i=0; $i < mb_strlen($input_string); $i++) {
			$char = mb_substr($input_string, $i, $i+1);
			$fraktur .= Fraktur::char2fraktur($char, $font);
		}
		
		return $fraktur;
	}
}
