<?php
/**
 * Create a ZIP archive from this site on the fly
 * 
 * - https://www.php.net/manual/en/class.ziparchive.php
 * - 
 * - 
 * - 
 * - 
 * - 
 * - https://gist.github.com/vielhuber/de2187cab0e74afa476c
 */

/**
 * ZIP file contents
 *
 * NOTE: Contains even files without any purpose
 * (like UnicodeSpecialChars.php, which may become )
 */
$zip_contents = Array(
	"LICENSE",
	"README.md",
	"index.php",
	"template.inc.php",
	"Fraktur.class.php",
	"main.js",
	"style.css",
	//"switch.css",
	"download.php",
	"UnicodeSpecialChars.php",
	"favicon.png"
);

/**
 * Root Directory to create inside the zip
 */
$zip_root_directory = "Fraktur-Generator";

/**
 * Archive download destination filename (for the
 * Content-Disposition header)
 * @link https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition
 */
$zip_filename = $zip_root_directory . "_app.malte70.de.zip";

/**
 * ZIP Archive Comment
 */
//$zip_archive_comment = "Fraktur-Generator";
$zip_archive_comment = <<<'EOT'
Fraktur-Generator              
        <https://app.malte70.de/Fraktur-Generator/>

This archive contains everything needed to run the PHP script on your
own web server.

SPDX-License-Identifier: MIT
EOT;


$tmpfile = tempnam("tmp", "zip");

$zip = new ZipArchive();
//if ($zip->open($tmpfile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== TRUE) {
if ($zip->open($tmpfile, ZipArchive::CREATE) !== TRUE) {
	// header("HTTP/1.0 418 I'm A Teapot");
	http_response_code(402);
	header("Content-Type: text/plain; charset=UTF-8");
	
	$error_exit_message = <<<'EOD'
Error in:
	ZipArchive::open(tempnam(…), ZipArchive::CREATE)

EOD;
	die($error_exit_message);
}

$zip->setArchiveComment($zip_archive_comment);

$zip->addEmptyDir($zip_root_directory);
foreach ($zip_contents as $f) {
	$data = file_get_contents($f);
	$zip->addFromString(
		$zip_root_directory . "/" . $f,
		file_get_contents($f)
	);
}
$zip->close();


ob_clean();
ob_end_flush();
header('Content-Type: application/zip');
header('Content-Length: ' . filesize($tmpfile));
header('Content-Disposition: attachment; filename="'.$zip_filename.'"');
readfile($tmpfile);
unlink($tmpfile); 
die();


