/**
 * https://app.malte70.de/Fraktur-Generator/main.js
 */

function isMobileBrowser() {
	return window.navigator.maxTouchPoints > 1;
}
console.debug("isMobileBrowser() = " + isMobileBrowser().toString());

function selectText(containerid) {
	/* https://stackoverflow.com/a/1173319 */
	if (document.selection) { // IE
		var range = document.body.createTextRange();
		range.moveToElementText(document.getElementById(containerid));
		range.select();
		
	} else if (window.getSelection) {
		var range = document.createRange();
		range.selectNode(document.getElementById(containerid));
		window.getSelection().removeAllRanges();
		window.getSelection().addRange(range);
		
	}
}

//document.addEventListener("DOMContentLoaded", function(){
window.addEventListener("load", function(e){
	const resultBlockQuote = document.querySelector("#result_blckqt");
	
	/**
	 * Don't add click events for mobile clients, because they make
	 * the site unusable.
	 */
	if (!isMobileBrowser()) {
		if (resultBlockQuote != null) {
			/**
			 * Select <blockquote> on single click
			 */
			resultBlockQuote.addEventListener(
				"click",
				function (e) {
					selectText(resultBlockQuote.id);
				}
			);

			/**
			 * Select <blockquote> on double click
			 */
			resultBlockQuote.addEventListener(
				"dblclick",
				function (e) {
					selectText(resultBlockQuote.id);
					document.execCommand('copy');
				}
			);
			
			console.group("Easter Eggs und Tipps");
			console.warn(
				"%cGeheim-Tipp\n(~außer für Handy-Nutzer)"
				+ "%cSobald Text umgewandelt wurde, kann das Resultat mit nur einem Klick markiert werden,\n"
				+ "und zwar inkl. Zeilenumbrüchem uws.\n"
				+ "Ein Doppel-Klick kopiert die markierten Daten zusätzlich direkt in die Zwischenablage.",
				//mit Einfach-Klick und´´mit einem einfachen Klick auf das Ergebnis
				//Ein Klick auf Auf nicht-mobilen Clients werden für das Result-Element click und double-click Handler definiert.",
				"display: block; font: 20px serif; text-align: center; margin: 40px 20px;",
				"display: block; font: 18px serif; text-align: center; margin: 0 18px 28px;"
			);
			console.groupEnd();
		}
		
	} else {
		console.info("Mobile browser detected.");
		
	}
});
