# Fraktur Unicode Text Converter

- [Unicode Block “Mathematical Alphanumeric Symbols”][uc-mas]
- [Unicode Sonderzeichen Copy&Paste :: dev.malte70.de][uc-cnp]

Text used for testing:

```
Lorem ipsum dolor sit amet.
0123456789
Ää Öö Üü ß
```


## Fix for letters found in different blocks

Most letters are located in the correct order inside the block „Mathematical Alphanumeric Symbols“,
but some are located in „Letterlike Symbols“, which contains mostly letters with a special meaning
in science, like `ℕ`, `ℝ` and `ℂ` are used for the sets of the natural, real and complex numbers.

```php
<?php

print "---------------\n";
print "Missing           => U+1D49D\n";
print "Real code         => U+212C\n";
print "Letter            => ℬ\n";
print "mb_ord()          => " . mb_ord('ℬ');
print "hexdec(mb_ord())  => " . dechex("212C");

$FixUnexpectedWrongCodepoint = Array(
	"1D49D" => "212C", # ℬ
	"1D4A0" => "2130", # ℰ
	"1D4A1" => "2131", # ℱ
	"1D4A3" => "210B", # ℋ
	"1D4A4" => "2110", # ℐ
	"1D4A7" => "2112", # ℒ
	"1D4A8" => "2133", # ℳ
	"1D4AD" => "211B", # ℛ
	"1D4BA" => "212F", # ℯ
	"1D4BC" => "210A", # ℊ
	"1D4C4" => "2134", # ℴ
	"1D506" => "212D", # ℭ
	"1D50B" => "210C", # ℌ
	"1D50C" => "2111", # ℑ
	"1D515" => "211C", # ℜ
	"1D51D" => "2128", # ℨ
	"1D53A" => "2102", # ℂ
	"1D53F" => "210D", # ℍ
	"1D545" => "2115", # ℕ
	"1D547" => "2119", # ℙ
	"1D548" => "211A", # ℚ
	"1D549" => "211D", # ℝ
	"1D551" => "2124", # ℤ
);

if (array_key_exists(dec2hex(mb_ord($c)), $FixUnexpectedWrongCodepoint)) {
	$f = mb_chr(
		hex2dec(
			$FixUnexpectedWrongCodepoint[
				dec2hex(
					mb_ord(
						$c
					)
				)
			]
		)
	);
}
?>
```



[uc-mas]: https://www.compart.com/en/unicode/block/U+1D400
[uc-cnp]: https://dev.malte70.de/unicode-copy-and-paste/


## JavaScript

- [How to paste text - web.dev](https://web.dev/patterns/clipboard/paste-text/)


