<?php
/**
 * @see https://de.wikipedia.org/wiki/Unicodeblock_Mathematische_alphanumerische_Symbole
 */

require_once("Fraktur.class.php");


if (array_key_exists("text", $_POST)) {
	$_text    = $_POST["text"];
	$_font    = $_POST["font"];
	$_replace = @$_POST["replace_umlauts"] == "on";
	$_POST["replace_umlauts"] = $_replace;
	
} elseif (array_key_exists("text", $_GET)) {
	$_text    = $_GET["text"];
	$_font    = $_GET["font"];
	$_replace = (@$_GET["replace_umlauts"] == "on");
	$_GET["replace_umlauts"] = $_replace;
	
} else {
	$_text    = "";
	$_font    = "BoldFraktur";
	$_replace = true;
	
}

/*
print("<pre>");
var_dump($_replace);
print("\n<br>");
$_replace = boolval(intval($_replace));
var_dump($_replace);
print("\n<br>");
print("</pre>");
die();
 */
$_replace = boolval(intval($_replace));

if (!empty($_text)) {
	$_fraktur = Fraktur::string2fraktur(
		$_text,
		$_font,
		$_replace
	);
}



//$submit_button_text = "Umwandeln";
$submit_button_text = Fraktur::string2fraktur("Umwandeln", "Fraktur");


$welcome = <<<EOT
				<p>
					Alle lateinischen Buchstaben werden durch Fraktur-Buchstaben ersetzt. Alle anderen Zeichen, ob Zahlen oder Emojis,
					bleiben unverändert. Da das auch Umlaute betrifft, schreib am besten „Ae“/„ae“, „Oe“/„oe“, „Ue“/„ue“ und „ss“ oder
					„sz“ statt „Ä“/„a“, „Ö“/„ö“, „Ü“/„ü“ und „ß“.
				</p>

EOT;


require_once("template.inc.php");


