<?php
/**
 * template.inc.php
 * 
 * Fraktur's Template
 */


$ResultBlock = "";
if ($_SERVER["REQUEST_METHOD"] == "POST" || ($_SERVER["REQUEST_METHOD"] == "GET" && !empty($_GET["text"]))) {
	// C64-like:
	//$ResultBlock = "<p><code>READY.</code></p>";

	// Butler
	$ResultBlock.= "\t\t\t<h3>Bitte sehr, ich habe Deinen Text";
	//$ResultBlock.= " versucht,";
	$ResultBlock.= " in <em>" . Fraktur::getFontPrettyName($_font) . "</em> umgewandelt:</h3>\n";
	$ResultBlock = "\t\t\t<blockquote id=\"result_blckqt\">\n";
	$ResultBlock.= "\t\t\t\t" . nl2br($_fraktur) . "\n";
	$ResultBlock.= "\t\t\t</blockquote>\n";

}


/**
 * Settings for the <form>
 */
$form_method = "POST";
if ($_SERVER["REQUEST_METHOD"] == "GET" && !empty($_GET["text"])) {
	$form_method = "GET";
}
$form_checkbox_umlauts_attrs = ($_replace === True ? " checked" : "");


?><!DOCTYPE html>
<html lang="de">
	<head>
		<meta charset="UTF-8">
		<meta name="viewport" content="width=device-width,initial-scale=1.0">

		<title>Fraktur Generator</title>

		<link rel="stylesheet" type="text/css" href="style.css">
		<link rel="icon" type="image/png" sizes="64x64" href="favicon.png">
	</head>

	<body id="top">
		<header>
			<h1>
				<a href="./">Fraktur-Generator</a>
			</h1>
		</header>
		
		<main>
			<article id="welcome">
<?=$welcome?>
			</article>
			

			<article id="converterForm">
				<form action="<?=$_SERVER['REQUEST_URI']?>" method="<?=$form_method?>">
					<label for="text" class="hidden">Dein Text</label>
					<textarea name="text" placeholder="Gib hier deinen Text ein..."><?=$_text?></textarea>

<?php /*
					<section class="inputGroup checkbox">
						<input type="checkbox" name="replace_umlauts" id="replace_umlauts"<?=$form_checkbox_umlauts_attrs?>>
						<label for="replace_umlauts">Umlaute ersetzen?</label>
						</section>
 */ ?>
					
					<!--<section class="inputGroup checkbox">-->
					<section class="inputGroup _checkbox">
						<label>
							<input type="checkbox" name="replace_umlauts" id="replace_umlauts"<?=$form_checkbox_umlauts_attrs?>>
							Umlaute ersetzen?
						</label>
					</section>
<span class="hidden">
</span>
					
					<section class="inputGroup">
						<label for="font">Schriftart</label>
						<select name="font">
<?php foreach (array_keys(Fraktur::$fontOffsets) as $font): ?>
							<option value="<?=$font?>"<?=($font==$_font?" selected":"")?>><?=Fraktur::getFontPrettyName($font)?></option>
<?php endforeach; ?>
						</select>
					</section>
						
					<section class="inputGroup">
						<button type="submit"><?=$submit_button_text?></button>
					</section>
				</form>
			</article>
			
<?php if (strtoupper(@$_GET["debug"]) == "YES"): ?>
			<code class="debug"><h2>Debug-Infos</h2>
<?php /*
<h3>$form_method</h3>
"<?=$form_method?>"

<?php
if ($form_method == "POST") {
	$request_data = $_POST;
} else {
	$request_data = $_GET;
}
print '<h3>$_' . $form_method . "</h3>\n";

foreach ($request_data as $k => $v) {
	print '$_GET["' . $k . '"] = ';
	if (stristr($v, "\n")) {
		print "&lt;&lt;&lt;EOT\n";
		print htmlspecialchars($v) . "\n";
		print "EOT;\n";
	} else {
		print "'" . $v . "\"\n";
	}
	print "\n";
}; print('<span style="color:red;">☭</span>');

*/

//$_text = substr($_text, 0, 20);
$_text = str_replace(
	"\r", "\n",
	str_replace(
		"\r\n", "\n",
		$_text
	)
);
$_text_exploded = explode("\n", $_text);
$_text          = $_text_exploded[0];
$_text          .= count($_text_exploded)>1 ? " <span class=\"ellipsis\">[...]</span>" : "";
//if (count($_text_exploded) > 1)
//	$_text .= " <span class=\"ellipsis\">[...]</span>";

?>
<h3>$_text, $_font &amp; $_replace</h3>
$_text    = "<?=$_text_shortened?>"
$_font    = "<?=$_font?>"
$_replace = "<?=$_replace?>"

</code>
<?php endif; ?>

			<article id="result">
				
				<?=$ResultBlock?>

			</article>
		</main>
		

		<footer>
			<p>
				<a href="https://app.malte70.de/Fraktur-Generator/">Fraktur-Generator</a> © 2020,2023 <a href="https://malte70.de" rel="me nofollow">malte70</a>
			</p>
			<p>
				<a href="download.php">Download (ZIP)</a>
			</p>
		</footer>

		<script type="text/javascript" src="main.js"></script>
	</body>
</html>
